/*
 * Copyright (c) 2020-2021 Sonos Inc.
 * All rights reserved.
 */

#if defined(CONFIG_MODVERSIONS) && ! defined(MODVERSIONS)
#include <linux/modversions.h>
#define MODVERSIONS
#endif

#include <linux/module.h>

#include "mdp.h"

#include <asm/mpc8247.h>

extern struct manufacturing_data_page sys_mdp;

extern int m8260_port_read(int port, int pin);
extern void m8260_port_set(int port, int pin, int flags);

#define m8260_cpm_dpalloc cpm_muram_alloc

#include "audioctl_led.h"

#include "audiodev_log.h"

#define LED_WHITE                       1
#define LED_AMBER                       4
#define LED_RED                         8

#define LED_GREEN_BUTTON                0x10
#define LED_OVERRIDE                    0x20

#ifndef COUNTOF
#define COUNTOF(x) (sizeof(x)/sizeof(x[0]))
#endif

struct timer_list ledtimer;
int actl_ledtimerdisable=0;
unsigned char actl_leddata[8]={0,LED_WHITE,0,LED_WHITE,0,LED_WHITE,0,LED_WHITE};
int actl_ledcur=0;
int led_pwm_state=0;

void audioctl_set_leds(unsigned long arg)
{
    int white_led, amber_led, red_led, green_led;
    int leds_swapped;

    actl_ledtimerdisable=((arg&LED_OVERRIDE)?1:0);

    if (WEMBLEY)
        white_led = (arg & LED_WHITE) ? PORT_SET_DAT : PORT_CLEAR_DAT;
    else
        white_led = (arg & LED_WHITE) ? PORT_CLEAR_DAT : PORT_SET_DAT;

    amber_led = (arg & LED_AMBER) ? PORT_CLEAR_DAT : PORT_SET_DAT;

    red_led = (arg & LED_RED) ? PORT_CLEAR_DAT : PORT_SET_DAT;
    green_led = (arg & LED_GREEN_BUTTON) ? PORT_CLEAR_DAT : PORT_SET_DAT;

    leds_swapped = (sys_mdp.mdp_hwfeatures & MDP_HWFEATURE_LED_SWAP);
    
    m8260_port_set(LED_WHITE_PORT, LED_WHITE_PIN, white_led);
    m8260_port_set(LED_AMBER_PORT, LED_AMBER_PIN, amber_led); 
    if (leds_swapped) {
        m8260_port_set(LED_RED_PORT, LED_RED_PIN, green_led); 
        m8260_port_set(LED_GREEN_PORT, LED_GREEN_PIN, red_led);
    } else {
        m8260_port_set(LED_RED_PORT, LED_RED_PIN, red_led); 
        m8260_port_set(LED_GREEN_PORT, LED_GREEN_PIN, green_led);
    }
}

void audioctl_ledtimer(unsigned long x)
{
    if (actl_ledtimerdisable==0) {
        if (actl_leddata[0]&actl_leddata[1]&actl_leddata[2]&actl_leddata[3]&actl_leddata[4]&actl_leddata[5]&actl_leddata[6]&actl_leddata[7]&LED_WHITE) {
            m8260_port_set(PORT_D,30,PORT_SET_PAR|PORT_SET_SOR);
            led_pwm_state=1;
        } else {
            m8260_port_set(PORT_D,30,PORT_CLEAR_PAR);
            led_pwm_state=0;
        }
        audioctl_set_leds(actl_leddata[actl_ledcur]);
    }
    actl_ledcur=((actl_ledcur+1)&(COUNTOF(actl_leddata)-1));
    mod_timer(&(ledtimer),jiffies+((3*HZ)/4));
}

void audioctl_init_leds(void)
{
    LOG_FUNCTION();
    init_timer(&ledtimer);
    ledtimer.data=0;
    ledtimer.function=audioctl_ledtimer;
    m8260_port_set(LED_RED_PORT,LED_RED_PIN,PORT_CLEAR_PAR|PORT_SET_DIR|PORT_SET_DAT);
    m8260_port_set(LED_AMBER_PORT,LED_AMBER_PIN,PORT_CLEAR_PAR|PORT_SET_DIR|PORT_SET_DAT);
    m8260_port_set(LED_GREEN_PORT,LED_GREEN_PIN,PORT_CLEAR_PAR|PORT_SET_DIR|PORT_SET_DAT);
    m8260_port_set(LED_WHITE_PORT,LED_WHITE_PIN,PORT_CLEAR_PAR|PORT_SET_DIR|PORT_CLEAR_DAT);
    audioctl_ledtimer(0);
    LOG_EXIT();
}